unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, YahooWeather;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Memo1: TMemo;
    RadioGroup1: TRadioGroup;
    procedure Button1Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
var tmpData:TYahooForecast;
    Counter:integer;
begin
  //memo1.Lines.Text:=GetYahooWeatherData(Edit1.Text);
  if RadioGroup1.ItemIndex=0 then
    tmpData := GetYahooForecast(Edit1.Text)
  else
    tmpData := GetYahooForecast(Edit1.Text,'f');

  memo1.lines.Clear;

  if tmpData.success then
    begin
      with tmpData do
        begin
          memo1.lines.add('Distance units: '+distance);
          memo1.lines.add('Pressure units: '+pressure);
          memo1.lines.add('Speed units: '+speed);
          memo1.lines.add('Temperature units: '+temperature);
          memo1.lines.add('City: '+location_city);
          memo1.lines.add('Country: '+location_country);
          memo1.lines.add('Region: '+location_region);
          memo1.lines.add('Wind Chill: '+wind_chill);
          memo1.lines.add('Wind Direction: '+wind_direction);
          memo1.lines.add('Wind Speed: '+wind_speed);
          memo1.lines.add('Humidity: '+atmosphere_humidity);
          memo1.lines.add('Pressure: '+atmosphere_pressure);
          memo1.lines.add('Rising: '+atmosphere_rising);
          memo1.lines.add('Visibility: '+atmosphere_visibility);
          memo1.lines.add('Sunrise: '+astronomy_sunrise);
          memo1.lines.add('Sunset: '+astronomy_sunset);
          memo1.lines.add('Latitude: '+location_latitude);
          memo1.lines.add('Longitude: '+location_longitude);
          memo1.lines.add('Reported: '+last_updated);
          memo1.lines.add('Current Code: '+current_code);
          memo1.lines.add('Current Data: '+current_date);
          memo1.lines.add('Current Temp: '+current_temp);
          memo1.lines.add('Current Text: '+current_text);
          memo1.lines.add('Forecast: ');

          for Counter:=0 to 9 do
            begin
              memo1.Lines.add('');
              memo1.lines.add('Day '+IntToStr(Counter)+' code: '+forecast[Counter].code);
              // memo1.lines.add('Day '+IntToStr(Counter)+' code: '+WeatherCode2String(forecast[Counter].code));
              memo1.lines.add('Day '+IntToStr(Counter)+' date: '+forecast[Counter].date);
              memo1.lines.add('Day '+IntToStr(Counter)+' day: ' +forecast[Counter].day);
              memo1.lines.add('Day '+IntToStr(Counter)+' high: '+forecast[Counter].high);
              memo1.lines.add('Day '+IntToStr(Counter)+' low: ' +forecast[Counter].low);
              memo1.lines.add('Day '+IntToStr(Counter)+' text: '+forecast[Counter].text);
            end;
        end;
    end;

end;

end.

