#!/system/bin/sh

#
#  FireTV USB Drive Mounter
#
#  REQUIRED: Busybox with support for run-parts, blkid, mount-helper
#  and stuff that's probably slipped my mind required.
#  AFAIK, NONE of the "free" Play Store busyboxes have all of the
#  supplied options. I suggest you use mine or compile your own.
#
#  This script has been tested with 4 drives
#  mounted (vfat,exfat,ntfs,ext4,hfs+)
#
#  This script mounts your drives in the order
#  they are encountered at mountpoints
#  /storage/usb/drive1,drive2,etc.
#  if you want to control the mountpoint for
#  your drives mount via UUID with mntdrives2.sh
#

i=0

busybox=/data/local/tmp/adbfire/busybox
busypath=/data/local/tmp/adbfire


mount -o remount,rw / 

if [[ $(ls /dev/block | $busybox grep -c 'sd') -eq 0 ]]; then 
        echo "no drives found"
	exit 1
fi

for f in /dev/block/sd??; do 
        drive=`echo $f | $busypath/sed -r 's/^.{11}//'`
	mountType=$($busybox blkid $f | $busypath/sed -n -e 's_^.*TYPE="\([^\"]*\)".*_\1_p');
	mountUUID=$($busybox blkid $f | $busypath/sed -n -e 's_^.*UUID="\([^\"]*\)".*_\1_p');
        #echo $mountUUID
        #echo $mountType


i=$((i+1))

  mkdir -p /storage/usb/drive$i;
  chmod 0777 /storage/usb/drive$i;
  chown shell.shell /storage/usb/drive$i

  if [[ $mountType == "exfat" ]]; then
     $busypath/mount.exfat-fuse -o rw $f /storage/usb/drive$i
  fi

  if [[ $mountType == "ntfs" ]]; then
        $busypath/ntfs-3g $f /storage/usb/drive$i
  fi


  if [[ $mountType == "hfsplus" ]]; then 
    $busypath/mount_ufsd_fuse $f /storage/usb/drive$i -o umask=000
  fi

  if [[ $mountType == "vfat" ]]; then
    mount -t vfat -o umask=000 $f /storage/usb/drive$i 
  fi


  if [[ $mountType == "ext4" ]] || [[ $mountType == "ext3" ]] || [[ $mountType == "ext2" ]]; then
    mount -w -o exec -t $mountType $f /storage/usb/drive$i
  fi

done  

mount -o remount,ro / 

#start samba if installed 

if [ -f /data/data/com.funkyfresh.samba/files/jocala.txt ]
  then
     $busypath/samba start  > /dev/null 2>&1
  fi




